﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class OrdersTax
    {

        public OrdersTax()
        {

        }

        public OrdersTax(IDataReader myDataRecord)
        {
            TaxID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("TaxID"));
            OrderID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrderID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("OrderID"));
            TaxName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TaxName"));
            TaxType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TaxType"));
            TaxValue = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxValue")) ? 0.00M: myDataRecord.GetDecimal(myDataRecord.GetOrdinal("TaxValue"));
            TaxAmount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TaxAmount")) ? 0.00M : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("TaxAmount"));
        }

        [DataObjectField(true, false, false)]
        public Guid TaxID { get; set; }

        public Guid OrderID{ get; set; }

        public string TaxName { get; set; }

        public string TaxType { get; set; }

        public decimal TaxValue { get; set; }

        public decimal TaxAmount { get; set; }
    }
}
